# Vespucci 13.1 Highlights

2019-06-30

This is a minor release consisting mainly of UI improvements.

### Updated opening hours editor

The opening hours editor (a separate project found [here](https://github.com/simonpoole/OpeningHoursFragment)) has received a number of updates, including

* tapping the time bars will start a large time picker, this was previously only available via the menu.
* ability to load and save templates to on device files.
* support for region and object type specific templates.

### Use of SAF file picker for Android KitKat and later

Previously, to give a consistent look and feel over as many different Android version as possible, we were using a third party file picker/selector for those operations that require a file to be selected for input or output. Unluckily in recent Android versions removable "SD card" storage has become unavailable due to this.

To work around this we are now using the system SAF (Storage Access Framework) file picker for Android KitKat (19) and later. This does have the advantage that cloud-based storage location are usable for operations that don't need direct file access.

### Download offline data directly with automatic configuration

To make using offline OSM data in [MSF format](https://www.openstreetmap.org/user/SimonPoole/diary/193235) easier we've added a small UI that will display the available files, download them with the Android download manager and configure a new API entry if necessary.

### Support for multi-line comments and source in the upload dialog, and multi-line text fields in the form tag editing UI

Comment and source field are now multi-line making adding longer texts far easier. Further multi-line input fields are supported in the form based tag editor, depending on the "length" attribute in the presets. 

### Improvements JS support

The layout of the JS console has been improved and scripts from preset fields are now evaluated after all fields have been set, allowing for order independent consistent behaviour. Further the key - preset mapping is now visible to scripts.  

### GPX and GeoJson files can be loaded via Intent

Clicking a GPS or GeoJson/Json file in a file manager should now show Vespucci as an app that can read the files.

### Go to coordinates function and OLC support

The "GPS" menu now features an item "Go to coordinates" that will display an input field that will accept coordinates in a wide range of formats and Open Location Codes. Further, the element information dialog will display the OLC equivalent of the coordinates for Nodes.
 
### Improvements JOSM style remote control

We now support imagery configuration and draft comment and source tags, see [Controlling Vespucci from other apps](http://vespucci.io/tutorials/vespucci_intents/). 

### Preset search now uses the name suggestion index (NSI) as an additional source

The preset search will now create temporary presets from matches of the search term with the name suggestion index. This resolves the issue of the NSI search dialog not being accessible in _simple mode_.

For example searching for _mcd_ will show a preset entry for a McDonald's as one of the first results. The results are filtered by country/region, if you are seeing results that are not applicable to where you are mapping this is likely due to missing country values in the NSI. Use of the NSI for name tags remains as is.

Issues with the NSI should be reported on the [NSI repo](https://github.com/osmlab/name-suggestion-index).

## Miscellaneous

* Data style configuration provided that doesn't render multi-polygons, this may help performance on slow devices.
* Lots of stability improvements.
* Support reading Overpass API generated OSM XML data from files.

# Upgrading from previous versions

* currently no special actions are required.

# Known problems

* the documentation is out of date.
* For known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)

